#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

bool process = true;

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);

	int t = 1;
	//cin >> t;
	while(process) {
		solve();
	}
#ifdef YA
	cerr << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

int mod = 1000000007;

int dp[2010][2010];

int getSum(int days, int L, int R) {
	if (L > R)
		return 0;
	return dp[days][R] - ((L == 0) ? 0 : dp[days][L - 1]);
}

li binpow(li q, li w) {
	if (!w)
		return 1;
	if (w & 1)
		return q * binpow(q, w - 1) % mod;
	return binpow(q * q % mod, w / 2);
}

void solve() {
	int n, x;
	li d;
	cin >> n >> d >> x;
	if (n == 0) {
		process = false;
		return;
	}
		

	memset(dp, 0, sizeof dp);
	dp[0][0] = 1;
	for (int days = 1; days <= n; ++days) {
		for (int j = 1; j <= n; ++j) {
			dp[days - 1][j] = (dp[days - 1][j - 1] + dp[days - 1][j]);
			if (dp[days - 1][j] >= mod)
				dp[days - 1][j] -= mod;
		}
		for (int sum = 0; sum <= n; ++sum) {
			int R = sum  - 1;
			int L = max(0, sum - x + 1);
			dp[days][sum] = getSum(days - 1, L, R);
			if (dp[days][sum] < 0)
				dp[days][sum] += mod;
			if (dp[days][sum] >= mod)
				dp[days][sum] -= mod;
		}
	}

	vector<li> c(n + 1);
	c[0] = 1;
	for (int i = 1; i <= n; ++i) {
		c[i] = c[i - 1] * 1LL * (d - i + 1) % mod * binpow(i, mod - 2) % mod;
		//cout << d << ' ' << i << ' ' << c[i] << endl;
	}

	li ans = 0;
	for (int days = 1; days <= n && days <= d; ++days)
		ans = (ans + c[days] * ((days == n) ? dp[days][n] : (dp[days][n] - dp[days][n - 1]))) % mod;

	ans = (ans + mod) % mod;

	cout << ans << "\n";

}